#if defined _authenticater_included
  #endinput
#endif
#define _authenticater_included


/**
 * Called when the user has been authenticated from core database
 *
 * @param id		index of player authenticated
 * @param key		save key for location in sql table
 * @param name[]	the name used for authentication purposes
 * @param pass[]	the password used for authentication
 */
forward player_authenticated(id, key, const name[], const pass[])

/**
 * Called when user is being deleted from database
 *
 * @param key		index of account being removed
 * @param name[]	the name used for authentication purposes
 * @param pass[]	the password used for authentication
 */
forward remove_acount(key)

/**
 * Called when user's login info in database is being updated, if your only coding plugins to use the key instead of saving their own copy of name+pass then this is useless
 *
 * @param key		database key id for account
 * @param name[]	the name used for authentication purposes
 * @param pass[]	the password used for authentication
 */
forward touch_acount(key, const name[], const pass[])

//Tells other plugins to do a full prune of their database
forward core_prune()

/**
 * @param slot		database key id to delete acount for
 *
 */
native delete_account(slot)

/**
 * @param id		id of player to look up slot id for database saving
 * @param string[]	if len is greater than 0 it'll put slot # in string passed, usefull if simply replacing get_user_authid in plugins that already are set up for saving
 * @len				size of string passed.
 * @return			slot id, -1 on error.
 */
native get_user_slotid(id, string[] = "", len = 0)