#include "cfg.h"

Cfg MainConfig;

int ParseInfoLine(char *infoline, char** InfoDatas, int MaxCount) {
	char** cdta = InfoDatas;
	int cnt = 0;
	char *dpos;
	char *cpos = infoline+1;
	if (*(infoline++) != '\\') {
		return -2;
	}

	if (MaxCount-- <= 0) {
		return -1;
	}

	do {
		dpos = strchr(cpos, '\\');
		if (dpos) {
			*(dpos++) = 0;
		}
		*(cdta++) = cpos;
		if (++cnt >= MaxCount) {
			return -1;
		}
		cpos = dpos;
	} while (cpos);

	*cdta = NULL;
	return cnt;
}

char* trimbuf(char *str) {
 	char *ibuf = str;
	int i = 0;

	if (str == NULL) return NULL;
	for (ibuf = str; *ibuf && isspace(*ibuf); ++ibuf)
		;
	
	i = strlen(ibuf);
	if (str != ibuf)
		memmove(str, ibuf, i);

	str[i] = 0;
	while (--i >= 0) {
		if (!isspace(ibuf[i]))
			break;
	}
	ibuf[++i] = 0;
	return str;
}

const char* GetAuthIidDescr(int id) {
	switch (id) {
		case 1:
			return "Real STEAM_x:x:x";
			break;
		case 2:
			return "Real VALVE_x:x:x";
			break;
		case 3:
			return "STEAM id generated by ip";
			break;
		case 4:
			return "VALVE id generated by ip";
			break;
		case 5:
			return "DEPRECATED";
			break;
		case 7:
			return "HLTV";
			break;
		case 8:
			return "STEAM_ID_LAN";
			break;
		case 9:
			return "STEAM_ID_PENDING";
			break;
		case 10:
			return "VALVE_ID_LAN";
			break;
		case 11:
			return "VALVE_ID_PENDING";
			break;
		case 12:
			return "STEAM_666:88:666";
			break;

		default:
			return "UNKNOWN";
	}
}

const char* GetStrAnswerType(int atid) {
	switch(atid) {
		case 0: return "New Style (Source)";
		case 1: return "Old (Source)";
		case 2: return "Hybrid";
		default: return "Unknown";
	}
}

Cfg::Cfg() {
	memset(RedirectCmd, 0, sizeof(RedirectCmd));
	memset(AltGameName, 0, sizeof(AltGameName));

	
	strcpy(Master_GameVersion, "1.1.2.6/Stdio");
	LoggingMode = 3;
	DisableNativeAuth = 0;
	HLStatsPlayerIdFix = 0;
	
	SubServer_Enable = 0;
	SubServer_IP = 0;
	SubServer_Port = 28015;
	SubServer_MasterClient = 1;
	SubServer_AnswerType = 1;
	IPGen_Prefix1 = 0;
	IPGen_Prefix2 = 0;
	ExportVersion = 1;
	eSTCompat = 0;
	cid_RevEmu = 1;
	cid_SteamEmu = 1;
	cid_OldRevEmu = 1;
	cid_Setti = 3;


    SteamEmuCompatMode = 1;
	MasterClient = 0;
	ServerInfoAnswerType = 0;
}

bool Cfg::ParseValidInfos(char* InfoLine, char *Buf, int BufSize, char** InfoFields, int MaxSz) {
	int res;
	strncpy(Buf, InfoLine, 1024);
	res = ParseInfoLine(Buf, InfoFields, MaxSz);
	switch (res) {
		case -1:
			LCPrintf(true, "[DPROTO]:  Too many fields in ValidInfoFields\n");
			return false;
		case -2:
			LCPrintf(true, "[DPROTO]:  ValidInfoFields: bad format\n");
			return false;
		case 0:
			LCPrintf(true, "[DPROTO]:  ValidInfoFields is empty!\n");
			return false;
	}
	return true;
}

bool Cfg::ParseParam(char* param, char* value) {
	int i;
	if (strcasecmp(param, "loggingmode") == 0) {
		i = atoi(value);
		if (i < 0 || i > 3) {
			LCPrintf(true, "[DPROTO]:  Invalid LoggingMode '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  LoggingMode = %d\n", i);
		LoggingMode = i;
		return true;
	} else if (strcasecmp(param, "cid_HLTV") == 0) {
		i = atoi(value);
		if (i < 3 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_HLTV value '%s'\n", value);
			return false;
		}
		cid_HLTV = i;
		LCPrintf(false, "[DPROTO]: AuthID for HLTV: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_NoSteam47") == 0) {
		i = atoi(value);
		if (i < 3 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_NoSteam47 value '%s'\n", value);
			return false;
		}
		cid_NoSteam47 = i;
		LCPrintf(false, "[DPROTO]: AuthID for No-steam p47 clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_NoSteam48") == 0) {
		i = atoi(value);
		if (i < 3 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_NoSteam48 value '%s'\n", value);
			return false;
		}
		cid_NoSteam48 = i;
		LCPrintf(false, "[DPROTO]: AuthID for No-steam p48 clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_Setti") == 0) {
		i = atoi(value);
		if (i < 3 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_Setti value '%s'\n", value);
			return false;
		}
		cid_Setti = i;
		LCPrintf(false, "[DPROTO]: AuthID for SETTI server scanner: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_RevEmu") == 0) {
		i = atoi(value);
		if (i < 1 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_RevEmu value '%s'\n", value);
			return false;
		}
		cid_RevEmu = i;
		LCPrintf(false, "[DPROTO]: AuthID for RevEmu clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_SteamEmu") == 0) {
		i = atoi(value);
		if (i < 1 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_SteamEmu value '%s'\n", value);
			return false;
		}
		cid_SteamEmu = i;
		LCPrintf(false, "[DPROTO]: AuthID for SteamEmu clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_OldRevEmu") == 0) {
		i = atoi(value);
		if (i < 1 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid OldRevEmu value '%s'\n", value);
			return false;
		}
		cid_OldRevEmu = i;
		LCPrintf(false, "[DPROTO]: AuthID for Old RevEmu clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_Steam") == 0) {
		i = atoi(value);
		if (i < 0 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_Steam value '%s'\n", value);
			return false;
		}
		cid_Steam = i;
		LCPrintf(false, "[DPROTO]: AuthID for steam clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "cid_SteamPending") == 0) {
		i = atoi(value);
		if (i < 3 || i > 12) {
			LCPrintf(true, "[DPROTO]:  Invalid cid_SteamPending value '%s'\n", value);
			return false;
		}
		cid_SteamPending = i;
		LCPrintf(false, "[DPROTO]: AuthID for steam unauthorized clients: %s\n", GetAuthIidDescr(i));
		return true;
	} else if (strcasecmp(param, "ServerBuild") == 0) {
		i = atoi(value);
		if (i <= 0) {
			LCPrintf(true, "[DPROTO]:  Invalid ServerBuild value '%s'\n", value);
			return false;
		}
		CurBuild = i;
		return true;
	} else if (strcasecmp(param, "HLStatsPlayerIdFix") == 0) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  Invalid HLStatsPlayerIdFix value '%s'\n", value);
			return false;
		}
		HLStatsPlayerIdFix = i;
		LCPrintf(false, "[DPROTO]:  Enable Fix for player ids on hlstats monitoring: %s\n", i?"ON":"OFF");
		return true;
	} else if (strcasecmp(param, "DisableNativeAuth") == 0) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  Invalid DisableNativeAuth value '%s'\n", value);
			return false;
		}
		DisableNativeAuth = i;
		LCPrintf(false, "[DPROTO]:  Disable Native Auth (Steam/Valve): %s\n", i?"ON":"OFF");
		return true;
		//
	} else if (strcasecmp(param, "SteamEmuCompatMode") == 0) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  Invalid SteamEmuCompatMode value '%s'\n", value);
			return false;
		}
		SteamEmuCompatMode = i;
		LCPrintf(false, "[DPROTO]: p47 Emus SteamEmuCompatMode : %s\n", i?"ON":"OFF");
		return true;
	} else if (strcasecmp(param, "ServerInfoAnswerType") == 0) {
		i = atoi(value);
		if (i < 0 || i > 3) {
			LCPrintf(true, "[DPROTO]:  Invalid ServerInfoAnswerType value '%s'\n", value);
			return false;
		}
		ServerInfoAnswerType = i;
		LCPrintf(false, "[DPROTO]:  ServerInfo answer type: %s\n", GetStrAnswerType(i));
		return true;
	} else if (strcasecmp(param, "SubServer_AnswerType") == 0) {
		i = atoi(value);
		if (i < 0 || i > 3) {
			LCPrintf(true, "[DPROTO]:  Invalid SubServer_AnswerType value '%s'\n", value);
			return false;
		}
		SubServer_AnswerType = i;
		LCPrintf(false, "[DPROTO]:  Secondary server ServerInfo answer type: %s\n", GetStrAnswerType(i));
		return true;
	} else if (!strcasecmp(param, "MasterClient")) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  Invalid MasterClient value '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  Enable master-client emulation on primary port: %s\n", i?"ON":"OFF");
		MasterClient = i;
		return true;
	} else if (!strcasecmp(param, "Master_GameVersion")) {
		strncpy(Master_GameVersion, value, sizeof(Master_GameVersion));
		Master_GameVersion[sizeof(Master_GameVersion)-1] = 0;
		LCPrintf(false, "[DPROTO]: This version of game will be used by master-client to send to master-servers: '%s'\n", Master_GameVersion);
		return true;
	} else if (!strcasecmp(param, "Game_Name")) {
		strncpy(AltGameName, value, sizeof(AltGameName));
		AltGameName[sizeof(AltGameName)-1] = 0;
		if (AltGameName[0]) {
			LCPrintf(false, "[DPROTO]: Setting game name to: '%s'\n", AltGameName);
		} else {
			LCPrintf(false, "[DPROTO]: Setting game name to: (Native game name)\n", AltGameName);
		}
		
		return true;
	} else if (!strcasecmp(param, "SubServer_Enable")) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  Invalid SubServer_Enable value '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  Enable secondary redirect-server: %s\n", i?"ON":"OFF");
		SubServer_Enable = i;
		return true;
	} else if (!strcasecmp(param, "IPGen_Prefix1")) {
		i = atoi(value);
		if (i < 0) {
			LCPrintf(true, "[DPROTO]:  Invalid IPGen_Prefix1 value '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  First prefix of authids genrated by ip: %d\n", i);
		IPGen_Prefix1 = i;
		return true;
	} else if (!strcasecmp(param, "IPGen_Prefix2")) {
		i = atoi(value);
		if (i < 0) {
			LCPrintf(true, "[DPROTO]:  Invalid IPGen_Prefix2 value '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  Second prefix of authids genrated by ip: %d\n", i);
		IPGen_Prefix2 = i;
		return true;
	} else if (!strcasecmp(param, "SubServer_IP")) {
		SubServer_IP = inet_addr(value);
		sockaddr_in saddr;
		SIN_SET_ADDR(&saddr.sin_addr, SubServer_IP)
		LCPrintf(false, "[DPROTO]:  Secondary server ip: %s\n", inet_ntoa(saddr.sin_addr));
		return true;
	} else if (!strcasecmp(param, "SubServer_Port")) {
		i = atoi(value);
		if (i < 0 || i > 65535) {
			LCPrintf(true, "[DPROTO]:  Invalid SubServer_Port value '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  Secondary server port: %d\n", i);
		SubServer_Port = i;
		return true;
	} else if (!strcasecmp(param, "SubServer_MasterClient")) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  Invalid SubServer_MasterClient value '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]:  Enable master client on secondary server: %s\n", i?"ON":"OFF");
		SubServer_MasterClient = i;
		return true;
	} else if (!strcasecmp(param, "SubServer_RedirectCommand")) {
		strncpy(RedirectCmd, value, sizeof(RedirectCmd));
		RedirectCmd[sizeof(RedirectCmd)-1] = 0;
		LCPrintf(false, "[DPROTO]:  Secondary server will execute this in connecting clients: '%s'\n", RedirectCmd);
		return true;
	} else if (!strncasecmp(param, "ValidInfoFields_", 16)) {
		return true;
	} else if (!strcasecmp(param, "OldEstCompatMode")) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  OldEstCompatMode '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]: Disable fix for steamids generated by eST in 0.3.1 version: %s\n", i ? "Yes" : "No");
		eSTCompat = i;
		return true;
	} else if (!strcasecmp(param, "ExportVersion")) {
		i = atoi(value);
		if (i < 0 || i > 1) {
			LCPrintf(true, "[DPROTO]:  ExportVersion '%s'\n", value);
			return false;
		}
		LCPrintf(false, "[DPROTO]: dp_version cvar will be exported: %s\n", i ? "Yes" : "No");
		ExportVersion = i;
		return true;
	}



	LCPrintf(true, "[DPROTO]:  Config line parsing failed: invalid parameter '%s'\n", param);	
	return false;
}

bool Cfg::LoadCfg() {
	char buf[1024];
	char gd[256];
	char *cl;
	char *vl;
	int cline = 0;

	sprintf(buf, "./%s", DPROTO_CFG);
	FILE *fl = fopen(buf, "r");
	if (fl == NULL) {
		GET_GAME_DIR(gd);
		sprintf(buf, "./%s/%s", gd, DPROTO_CFG);
		fl = fopen(buf, "r");
		if (fl == NULL) {
			LCPrintf(true, "[DPROTO]:  Failed to load config: cant found %s in server root and gamedir\n", DPROTO_CFG);
			return false;
		}
	}

	LCPrintf(true, "[DPROTO]:  Loading config '%s'\n", buf);
	while (fgets(buf, sizeof(buf), fl)) {
		cline++;
		cl = trimbuf(buf);
		if (strlen(cl) == 0 || cl[0] == '#') continue;
		vl = strchr(cl, '=');
		if (vl == NULL) {
			LCPrintf(true, "[DPROTO]:  Failed to load config: parsing error on line %d\n", cline);
			fclose(fl);
			return false;
		}
		*(vl++) = 0;
		cl = trimbuf(cl);
		vl = trimbuf(vl);
		if (!ParseParam(cl, vl)) {
			LCPrintf(true, "[DPROTO]:  Failed to load config: parsing error on line %d\n", cline);
			fclose(fl);
			return false;
		}
	}
	fclose(fl);
	LCPrintf(true, "[DPROTO]:  Config sucessfully loaded.\n");
	return true;
}


void LCPrintf(bool Critical, char *fmt, ... ) {
	va_list			argptr;
	static char		string[1024];
	
	va_start ( argptr, fmt );
	vsnprintf ( string, sizeof(string), fmt, argptr );
	va_end   ( argptr );

	if (MainConfig.LoggingMode & 1 || Critical)
		SERVER_PRINT(string);
	if (MainConfig.LoggingMode & 2 || Critical)
		ALERT(at_logged, string);
}
